﻿using System;
using System.Collections.Generic;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Linq;
using VIRP.EFR.BO;
using VIRP.EFR.BLL;
using VIRP_WEB.BaseCode;
using System.Web.Security.AntiXss;

namespace VIRP_WEB.Custom.EFR
{
    public partial class ReferralContact : EfrBasePage
    {
        CONTACT_LOG contact;
        Uri referrer;

        private static IReadOnlyList<string> navigationSources = new List<string>
        {
        "/custom/efr/referrals/biocontactfollowups.aspx",
        "/custom/efr/referrals/referral.aspx",
        "/custom/efr/tools/eventreminders.aspx",
        "/custom/efr/referrals/referralcontactlog.aspx"
        };

        Int32 referralId = -1;

        public ReferralContact()
        {
        }

        protected override void Page_Load(object sender, EventArgs e)
        {
            int.TryParse(Request.QueryString["referralId"], out referralId);

            SetupCommonDataSourceParameters();

            if (!IsPostBack)
            {
                string title = "My Tasks > Contact Logs > All Contacts > Referral # " + referralId.ToString();

                DdlTimes.Items.AddRange(new[] { new ListItem("AM", "0"), new ListItem("PM", "1") });
                DdlTimes.SelectedIndex = 0;
                referrer = Request.UrlReferrer; 

                //populate contact methods
                ddlContactMethod.Items.AddRange(new[] { new ListItem("Email", "0"),
                    new ListItem("Phone", "1"), new ListItem("Fax", "2"),
                    new ListItem("Mail", "3"), new ListItem("In Person", "4") });
                //default contact method to Phone
                ddlContactMethod.SelectedIndex = 1;

                //reminder date should not be a past date

                FollowupRequiredDateValidator.ValueToCompare = DateTime.Today.ToShortDateString();
                ReminderDateValidator.ValueToCompare = DateTime.Today.ToShortDateString();

                int contactId;
                //only existing contacts
                if (int.TryParse(Request.QueryString["contactId"], out contactId))
                {
                    GetRefreshContact(contactId);
                    lblContactInitiator.Text = contact.CREATEDBY;

                    title += " > Log # " + contactId.ToString();
                }
                else
                {
                    contact = new CONTACT_LOG();
                    lblContactInitiator.Text = System.Threading.Thread.CurrentPrincipal.Identity.Name;

                    title += " > New Log";
                }

                SetupContact();

                ((Label)Master.FindControl("EfrPageTitle")).Text = title;
            }
        }

        private void SetupCommonDataSourceParameters()
        {
            ObjectDataSourcePatient.SelectParameters["CURRENT_USER"].DefaultValue = CurrentUser;
            ObjectDataSourcePatient.SelectParameters["CURRENT_REGISTRY_ID"].DefaultValue = CurrentRegistryId.ToString();
            ObjectDataSourcePatient.SelectParameters["REFERRAL_ID"].DefaultValue = referralId.ToString();
        }

        protected override void LoadViewState(object savedState)
        {
            if (savedState != null)
            {
                // Load State from the array of objects that was saved at 
                // SavedViewState.
                object[] allStates = (object[])savedState;
                if (allStates[0] != null)
                    base.LoadViewState(allStates[0]);
                if (allStates[1] != null)
                    contact = (VIRP.EFR.BO.CONTACT_LOG)allStates[1];
                if (allStates[2] != null)
                    referrer = (Uri)allStates[2];
            }
        }

        protected override object SaveViewState()
        {
            object baseState = base.SaveViewState();

            object[] allStates = new object[3];
            allStates[0] = baseState;
            allStates[1] = contact;
            allStates[2] = referrer;

            return allStates;
        }

        protected void SaveButton_Click(object sender, EventArgs e)
        {
            if (SaveCompleteContact())
            {
                Uri from = referrer as Uri;
                if (from != null && navigationSources.Contains(from.LocalPath.ToLower()))
                {
                    string js = "<script type='text/javascript'>alert('Inserted Successfully');window.location.replace('";
                    js += from.PathAndQuery;
                    js += "');</script>";

                    ClientScript.RegisterStartupScript(typeof(Page), "alertMessage", js);
                }
            }
            else
            {
                ServiceInterfaceManager.LogError("Failed to save ContactLogEntry", string.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CurrentUser, CurrentRegistryId);

                ClientScript.RegisterStartupScript(typeof(Page), "alertMessage", "<script type='text/javascript'>alert('Save Failed');</script>");
            }
        }
        
        private bool SaveCompleteContact()
        {
            contact.CONTACT_FIRST_NAME = TxtContactFirstName.Text.Trim();
            contact.CONTACT_LAST_NAME = TxtContactLastName.Text.Trim();
            var timeEntry = String.IsNullOrEmpty(TxtContactTime.Text.Trim()) ? "12:00" : TxtContactTime.Text.Trim();

            if (timeEntry.IndexOf(":") < 1)
                timeEntry = timeEntry + ":00";

            var time = timeEntry.Split(':');
            var ampm = DdlTimes.SelectedItem.Text == "AM" ? 0 : 12;

            contact.CONTACT_DATE = DateTime.Parse(ContactDate.DateValue.Trim()).AddHours(Double.Parse(time[0]) + ampm).AddMinutes(Double.Parse(time[1]));

            contact.CONTACT_METHOD_TEXT = ddlContactMethod.SelectedItem.Text;
            contact.CONTACT_PHONE = txtContactPhone.Text.Trim();
            contact.CONTACT_EMAIL = txtContactEMailAddr.Text.Trim();
            contact.CONTACT_ADDR1 = txtContactAddr1.Text.Trim();
            contact.CONTACT_ADDR2 = txtContactAddr2.Text.Trim();
            contact.CONTACT_ADDR3 = txtContactAddr3.Text.Trim();
            contact.CONTACT_CITY = txtContactCity.Text.Trim();
            contact.CONTACT_STATE = txtContactState.Text.Trim();
            contact.CONTACT_ZIPPLUS4 = txtContactPlus4.Text.Trim();
            contact.CONTACT_POSTAL = txtContactZip.Text.Trim();
            contact.CONTACT_COUNTRY = txtContactCountry.Text.Trim();
            contact.CONTACT_REASON_TEXT = TxtContactReason.Text.Trim();
            contact.CONTACT_MESSAGE_TEXT = TxtContactText.Text.Trim();

            contact.TELEMEDICINE_PATIENT_FLAG = (int.Parse(rbPatientConsultation.SelectedValue) == 1);
            contact.TELEMEDICINE_PROVIDER_FLAG = (int.Parse(rbProviderConsultation.SelectedValue) == 1);
            contact.INPATIENT_EVAL_RECOM_FLAG = (int.Parse(rbInpatientEval.SelectedValue) == 1);
            contact.FOLLOWUP_REQUIRED_FLAG = (int.Parse(rbFollowup.SelectedValue) == 1);
            contact.INPATIENT_EVAL_DATE = Helpers.ConvertStringToNullable<DateTime>(InpatientEvalDate.DateValue.Trim());
            contact.FOLLOWUP_REQUIRED_DATE = Helpers.ConvertStringToNullable<DateTime>(FollowupRequiredDate.Text.Trim());

            contact.FOLLOWUP_COMPL_DATE = Helpers.ConvertStringToNullable<DateTime>(FollowupCompletedDate.DateValue.Trim());
            contact.DATE_REMIND_ME_ON = Helpers.ConvertStringToNullable<DateTime>(ReminderDate.Text.Trim());

            // Only update the referral_id if it isn't already set
            if (contact.REFERRAL_ID <= 0)
            {
                contact.REFERRAL_ID = referralId;
            }
            
            int cId = CONTACT_LOGManager.Save(CurrentUser, CurrentRegistryId, contact);

            if (cId > 0)
                return true;
            else
                return false;
        }

        private void SetupContact()
        {
            TxtContactFirstName.Text = contact.CONTACT_FIRST_NAME;
            TxtContactLastName.Text = contact.CONTACT_LAST_NAME;

            var contactDateTime = contact.CONTACT_DATE.HasValue ? contact.CONTACT_DATE.Value : DateTime.Now;

            ContactDate.DateValue = String.Format("{0:d}", contactDateTime);
            TxtContactTime.Text = contactDateTime.ToString("hh:mm");

            var time = contactDateTime.ToString("hh:mm tt").Split(' ');

            DdlTimes.SelectedIndex = time[1] == "AM" ? 0 : 1;

            ddlContactMethod.SelectedIndex = ddlContactMethod.Items.IndexOf(ddlContactMethod.Items.FindByText(contact.CONTACT_METHOD_TEXT));
            txtContactPhone.Text = contact.CONTACT_PHONE;
            txtContactEMailAddr.Text = contact.CONTACT_EMAIL;

            txtContactAddr1.Text = contact.CONTACT_ADDR1;
            txtContactAddr2.Text = contact.CONTACT_ADDR2;
            txtContactAddr3.Text = contact.CONTACT_ADDR3;
            txtContactCity.Text = contact.CONTACT_CITY;
            txtContactState.Text = contact.CONTACT_STATE;
            txtContactZip.Text = contact.CONTACT_POSTAL;
            txtContactPlus4.Text = contact.CONTACT_ZIPPLUS4;
            txtContactCountry.Text = contact.CONTACT_COUNTRY;
            TxtContactReason.Text = contact.CONTACT_REASON_TEXT;
            TxtContactText.Text = contact.CONTACT_MESSAGE_TEXT;

            rbProviderConsultation.SelectedIndex = rbProviderConsultation.Items.IndexOf(rbProviderConsultation.Items.FindByValue(Convert.ToInt32(contact.TELEMEDICINE_PROVIDER_FLAG).ToString()));
            rbPatientConsultation.SelectedIndex = rbPatientConsultation.Items.IndexOf(rbPatientConsultation.Items.FindByValue(Convert.ToInt32(contact.TELEMEDICINE_PATIENT_FLAG).ToString()));
            rbInpatientEval.SelectedIndex = rbInpatientEval.Items.IndexOf(rbInpatientEval.Items.FindByValue(Convert.ToInt32(contact.INPATIENT_EVAL_RECOM_FLAG).ToString()));
            rbFollowup.SelectedIndex = rbFollowup.Items.IndexOf(rbFollowup.Items.FindByValue(Convert.ToInt32(contact.FOLLOWUP_REQUIRED_FLAG).ToString()));

            InpatientEvalDate.DateValue = contact.INPATIENT_EVAL_DATE.HasValue ? String.Format("{0:d}", contact.INPATIENT_EVAL_DATE.Value) : String.Empty;

            FollowupRequiredDate.Text = contact.FOLLOWUP_REQUIRED_DATE.HasValue ? String.Format("{0:d}", contact.FOLLOWUP_REQUIRED_DATE.Value) : String.Empty;
            ReminderDate.Text = contact.DATE_REMIND_ME_ON.HasValue ? String.Format("{0:d}", contact.DATE_REMIND_ME_ON.Value) : String.Empty;
            FollowupCompletedDate.DateValue = contact.FOLLOWUP_COMPL_DATE.HasValue ? String.Format("{0:d}", contact.FOLLOWUP_COMPL_DATE.Value) : String.Empty;
        }
        private void GetRefreshContact(int cId)
        {
            contact = VIRP.EFR.BLL.CONTACT_LOGManager.GetItem(CurrentUser, CurrentRegistryId, cId);

            if (contact == null)
            {
                ServiceInterfaceManager.LogError("Failed to load ContactLogEntry - cId: " + cId.ToString(), string.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CurrentUser, CurrentRegistryId);
            }
        }
    }
}
